# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 6
# Experiment: DAxDA, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR6_strategy.txt
# LLM Suggested Fallback: D

def harmony_seeker_optimizer(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    trust_meter = sum(1 for x in opp_history if x == "C")  # Actually tracks cooperation
    
    # Phase 1: Build trust (Rounds 1-3)
    if current_round <= 3:
        return "C"
    
    # Phase 2: Strategic defection (Rounds 4-6)
    elif current_round == 4:
        return "D"
    elif current_round == 5:
        return "C"
    elif current_round == 6:
        if len(opp_history) >= 5 and opp_history[4] == "C":
            return "D"
        else:
            return "C"
    
    # Phase 3: Adaptive exploitation (Rounds 7-10)
    else:
        if trust_meter >= 5:
            return "D"
        else:
            # Alternate to confuse
            return "D" if current_round % 2 == 0 else "C"